//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: 
//****************************************** 
//******************************************
//Stack Pointer	=	0x13f (If use mq6801_startup.asm)
//Ram range = 0x40~0x13f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6811.h"
#include "MQ6801_REG_BIT.h"

#define 	ulong unsigned long

void	send_data(ulong dd1);


void	delay(void);


ulong ADC_Converse(char Vref ,char AIN);

unsigned long  ADC_correct;

//*************************************************************************************************


uchar	temp1;



//*************************************************************************************************


void main()
{	CGCR.byte   = 0x02;	// 0x00: fcgck = fc/4;	0x01: fcgck = fc/2;  10: fcgck = fc
	
	P4CR.bit.b6=0;		//set P46 as input pin
	P4PU.byte=0;		//disable all built-in pull-up resistors of P4

	P7CR.byte=0xff;
	P9CR.byte=0xff;

  while(1)   
	{		
	ADC_correct =ADC_Converse(2,6);    //set reference voltage to internal 2V and analog input to AIN6

//		P7DR.bit.b4=0;						
//		P9DR.bit.b0=0;						
	send_data(ADC_correct);
//		P7DR.bit.b4=1;
//		P9DR.bit.b0=1;						
	}
	
}





//*************************************************************************************************
void	delay(void)
{
	
	temp1=0;
	while(temp1<10)
		{temp1++;
		__asm("NOP");	
		clr_wdt;
			}
	
	
}




//*************************************************************************************************
void	send_data(ulong dd1)
{
	uchar	tt1;
	

	for(tt1=0;tt1<12;tt1++)
	{
	P7DR.bit.b2=0;
		
	if((dd1&0x00000800)==0)
		{delay();}
		
		else{delay();
			delay();delay();};
	
	
	P7DR.bit.b2=1;
	
//	if(tt1==11)break;   increase the time interval between the 2 data to observe the AD values easily
	
	delay();
	delay();
	delay();
	delay();
	delay();
			
	dd1<<=1;			
		
		
		
	}
	
}














